﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="PPKWnioski.aspx.cs" Inherits="KOLKaP_WEB.KOLKaP.PPKWnioski" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>Deklaracje uczestnika PPK</title>
    <link href="../Web.css?2" type="text/css" rel="stylesheet" />
    <link rel="stylesheet" href="../jquery/themes/ui-lightness/jquery-ui-1.9.2.custom.min.css" />
    <script src="../jquery/jquery-1.8.3.min.js" type="text/javascript"></script>
    <script src="../jquery/ui/jquery-ui-1.9.2.custom.min.js" type="text/javascript"></script>
    <script src="../jquery/ui/i18n/jquery.ui.datepicker-pl.js" type="text/javascript"></script>
    <script src="../jquery/jquery.blockUI.js" type="text/javascript"></script>
    <script type="text/javascript">
        $(function () {
            $('#tbDataOd').datepicker({ dateFormat: 'yy-mm-dd', changeMonth: true, changeYear: true, showAnim: '', yearRange: '1970:2060', showOn: 'button', buttonImage: '../img/calendar.gif', buttonImageOnly: true });
            $('#tbDataDo').datepicker({ dateFormat: 'yy-mm-dd', changeMonth: true, changeYear: true, showAnim: '', yearRange: '1970:2060', showOn: 'button', buttonImage: '../img/calendar.gif', buttonImageOnly: true });

            $("#tbDataOd").datepicker("option", "dateFormat", 'yy-mm-dd');
            $("#tbDataDo").datepicker("option", "dateFormat", 'yy-mm-dd');

            $("#btnOdswiez").button({ icons: { primary: 'ui-icon-refresh' } });
            $(".btnOtworzGrid").button({ icons: { primary: 'ui-icon-folder-open' } });
            $("#btnDodaj").button({ icons: { primary: 'ui-icon-plusthick' } });

            //w ff nie widać za bardzo że jest disabled więc ustawiamy z ręki
            //if (!$("#btnRaport").attr('href')) {
            //    $("#btnRaport").addClass("ui-state-disabled");
            //}

        });

    </script>
</head>
<body onload="WydrukRezygnacji();">
    <form id="form1" runat="server">
        <div>
            <asp:Label ID="lblError" runat="server"></asp:Label>
            <asp:Label ID="lblKomunikat" runat="server"></asp:Label>
            <table class="bodyLRT0" cellspacing="0" cellpadding="0" width="100%" border="0">
                <tr>
                    <td colspan="5"><span style="font-size: 12pt; font-weight: bold">Deklaracje uczestnika PPK</span></td>
                </tr>
                <tr>
                    <td colspan="2" style="width: 25%" valign="bottom">
                        <small>
                            <asp:Label ID="lblNazwisko" runat="server">Nazwisko</asp:Label></small><br />
                        <asp:TextBox ID="tbNazwisko" Width="95%" runat="server"></asp:TextBox>
                    </td>
                    <td colspan="2" style="width: 30%" valign="bottom">
                        <small>
                            <asp:Label ID="lblImie" runat="server">Imię</asp:Label></small><br />
                        <asp:TextBox ID="tbImie" Width="100%" runat="server"></asp:TextBox>
                    </td>
                    <td colspan="1" style="text-align: right" valign="bottom">
                    </td>
                </tr>
                <tr>
                    <td style="width: 25%" valign="bottom">
                        <small>Jednostka</small><br />
                        <asp:DropDownList ID="ddlJednostka" runat="server" Width="90%"></asp:DropDownList>
                    </td>
                    <td style="width: 15%" valign="bottom">
                        <small>od (rrrr-mm-dd)</small><br />
                        <asp:TextBox ID="tbDataOd" Width="80%" runat="server"></asp:TextBox>
                    </td>
                    <td style="width: 15%" valign="bottom">
                        <small>do (rrrr-mm-dd)</small><br />
                        <asp:TextBox ID="tbDataDo" Width="80%" runat="server"></asp:TextBox>
                    </td>
                    <td style="width: 30%" valign="bottom">
                        <small>Status</small><br />
                        <asp:DropDownList ID="ddlStatus" Width="100%" runat="server">
                            <asp:ListItem Value="0" Selected="True">Wszystkie</asp:ListItem>
                            <asp:ListItem Value="WPR">Wprowadzone</asp:ListItem>
                            <asp:ListItem Value="OCK_PAP">Oczekujące na wer. papier.</asp:ListItem>
                            <asp:ListItem Value="ZAT">Zrealizowane</asp:ListItem>
                            <asp:ListItem Value="ANU">Anulowane</asp:ListItem>
                        </asp:DropDownList>
                    </td>
                    <td style="width: 15%; text-align: right" valign="bottom">
                        <small></small>
                        <br />
                        <asp:LinkButton ID="btnOdswiez" runat="server" Text="Odśwież" Width="90px" CssClass="aspButton" OnClick="btnOdswiez_Click"></asp:LinkButton>
                    </td>
                </tr>
                <tr>
                    <td colspan="5">
                        <asp:LinkButton ID="btnDodaj" runat="server" Text="Dodaj" Width="90px" CssClass="aspButton" OnClick="btnDodaj_Click"></asp:LinkButton>
                    </td>
                </tr>
            </table>
        </div>
        <div>
            <div id="divLiczbaWierszy" runat="server" class="Table" style="width: 100%; display: none; position: relative; height: 23px; background-color: White;">
                <div style="float: left; position: absolute; bottom: 2px;">
                    <asp:Label ID="lblLiczbaWierszy" runat="server"></asp:Label>
                </div>
            </div>
            <asp:GridView ID="gvListy" runat="server" CssClass="aspGrid" Width="100%" AutoGenerateColumns="False" AllowSorting="True" DataSourceID="sdsListy" DataKeyNames="ID_WNIOSKU,STATUS,PRACOWNIK,JEDNOSTKA,STANOWISKO,STATUS_NAZWA,ID_DEKLARACJI_SLOWNIK,PROCENT_SKLADKI,NAZWA_INSTYTUCJI_POPRZEDNIEGO_PPK,KOD_DEKLARACJI,ID_PRACOWNIKA,DATA_UTWORZENIA,EMAIL,TEL" OnRowCommand="gvListy_RowCommand" AllowPaging="True">
                <Columns>
                    <asp:TemplateField ShowHeader="False">
                        <ItemTemplate>
                            <asp:LinkButton ID="lbOtworzGrid" class="btnOtworzGrid" runat="server" CausesValidation="false" CommandName="OTWORZ" CommandArgument='<%# Container.DataItemIndex %>' Text="Otwórz"></asp:LinkButton>
                        </ItemTemplate>
                        <ItemStyle VerticalAlign="Middle" />
                    </asp:TemplateField>
                    <asp:BoundField DataField="PRACOWNIK" HeaderText="Nazwisko imię" SortExpression="PRACOWNIK" />
                    <asp:BoundField DataField="NR_KARTOTEKI" HeaderText="Nr kartot." SortExpression="NR_KARTOTEKI" />
                    <asp:BoundField DataField="JEDNOSTKA" HeaderText="Jednostka" SortExpression="JEDNOSTKA" />
                    <asp:BoundField DataField="STANOWISKO" HeaderText="Stanowisko" SortExpression="STANOWISKO" />
                    <asp:BoundField DataField="DEKLARACJA" HeaderText="Deklaracja" SortExpression="DEKLARACJA" />
                    <asp:BoundField DataField="STATUS_NAZWA" HeaderText="Status" SortExpression="STATUS_NAZWA" />
                    <asp:BoundField DataField="PROCENT_SKLADKI" HeaderText="Procent skł." SortExpression="PROCENT_SKLADKI" />
                    <asp:BoundField DataField="NAZWA_INSTYTUCJI_POPRZEDNIEGO_PPK" HeaderText="Nazwa instytucji" SortExpression="NAZWA_INSTYTUCJI_POPRZEDNIEGO_PPK" />
                    <asp:BoundField DataField="DATA_UTWORZENIA" HeaderText="Data utworzenia" DataFormatString="{0:yyyy-MM-dd HH:mm}" SortExpression="DATA_UTWORZENIA" />
                    <asp:BoundField DataField="DATA_PAPIER" HeaderText="Data wersji papier." DataFormatString="{0:yyyy-MM-dd}" SortExpression="DATA_PAPIER" />
                    <asp:BoundField DataField="PRZYJAL_PAPIER" HeaderText="Przyjmujący papier" SortExpression="PRZYJAL_PAPIER" />
                    <asp:BoundField DataField="DATA_ZATWIERDZENIA" HeaderText="Data zatwierdzenia" DataFormatString="{0:yyyy-MM-dd HH:mm}" SortExpression="DATA_ZATWIERDZENIA" />
                    <asp:BoundField DataField="ZATWIERDZAJACY" HeaderText="Zatwierdzający" SortExpression="ZATWIERDZAJACY" />
                    <asp:BoundField DataField="DATA_ANULOWANIA" HeaderText="Data anulowania" DataFormatString="{0:yyyy-MM-dd HH:mm}" SortExpression="DATA_ANULOWANIA" />
                    <asp:BoundField DataField="ANULUJACY" HeaderText="Anulujący" SortExpression="ANULUJACY" />
                </Columns>
                <PagerSettings Position="Top" />
                <RowStyle CssClass="TableItem" />
                <SelectedRowStyle CssClass="TableItemSelected" />
                <HeaderStyle CssClass="TableHeader" />
                <AlternatingRowStyle CssClass="TableItemAlt" />
            </asp:GridView>
            <asp:SqlDataSource ID="sdsListy" runat="server" ProviderName="System.Data.SqlClient" SelectCommand="PPK_WNIOSKI_LIST" SelectCommandType="StoredProcedure" ConnectionString="r" CancelSelectOnNullParameter="False" OnSelected="sdsListy_Selected">
                <SelectParameters>
                    <asp:SessionParameter Name="P_ID_FIRMY" SessionField="ID_FIRMY" />
                    <asp:ControlParameter ControlID="tbNazwisko" Name="P_NAZWISKO" PropertyName="Text" Type="String" ConvertEmptyStringToNull="False" />
                    <asp:ControlParameter ControlID="tbImie" Name="P_IMIE" PropertyName="Text" Type="String" ConvertEmptyStringToNull="False" />
                    <asp:ControlParameter ControlID="tbDataOd" Name="P_DATA_OD" PropertyName="Text" Type="DateTime" />
                    <asp:ControlParameter ControlID="tbDataDo" Name="P_DATA_DO" PropertyName="Text" Type="DateTime" />
                    <asp:ControlParameter ControlID="ddlStatus" Name="P_STATUS" PropertyName="SelectedValue"
                        Type="String" />
                    <asp:ControlParameter ControlID="ddlJednostka" Name="P_ID_MPZ" PropertyName="SelectedValue" />
                </SelectParameters>
            </asp:SqlDataSource>
        </div>
        <iframe id="Panel" name="Panel" src="PPKWnioskiWydrukPdf.aspx" frameborder="0" runat="server"></iframe>
    </form>
</body>
</html>
